<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_group()
    {
        return $this->belongsTo('User_group', 'user_group_id');
    }

    public function group()
    {
        return $this->hasMany('User_group', 'user_id');
    }

    public function update_log()
    {
        return $this->hasMany('App\Models\Log', 'user_id');
    }

}